# History  of Web App Development

### Objective

The Objective of this session is to set expectations for the course, make sure everybody has the right environment setup, as well as gauge the existing knowledge

### What we will talk about

* Course Expectations (10 min)
	* Grading Scheme
	* Topics Covered
	* My Expectations
* A short history of web apps (15 min)
* The mental model of the web for a developer (15 min)

### Before you come

* Watch [Bret Victor   The Future of Programming - YouTube](https://www.youtube.com/watch?v=8pTEmbeENF4)
	* It’s easy to adopt new technology, it’s hard to adopt new ideas.

## Long ago…
There was an internet made for documents.  The original intent was for sharing information among scientists and knowledge seekers, a web of hyperlinks, much like wikipedia.

However, not so long after companies recognised the potential of publishing their own websites, and as commercial pressure rose, the web evolved.

It started with media.
The document structure that was made to accommodate only the most basic of text formatting received images, then using tables developers would try to enforce grid based layout .

With demand for more engaging visuals, companies like macromedia and oracle developed **web applications** (Flash, Java) that can be embedded in webpages and play animations and video.

> It is worth noting that expert developers at the time came from a desktop development environment, the idea of open standard was not as popular, and reliable open source projects were not as appealing to enterprise.  
> Technology that is backed by a dedicated well known company has the tendency to be adopted faster due to it’s low risk.  
> The paradigm of client-server, exists outside the browser  

JavaScript came and it allowed developers to hack their own functionality into webpages, delivering more control.

Companies realise that the web can be used as a platform for delivering service, and documents became forms that submit to servers that render programatically different views. (PHP)

With the rise of this paradigm Content Management Systems (CMS) were born. and non developers could run web based systems.

As the web based systems became more complex. Style (CSS), Content (HTML), Client Side System Functionality (JS), Server Side System Functionality (PHP), and Server Side View Rendering Logic needed to be clearly separated.

At the time developers divided by type and **separation of concerns** became a mantra.

The Backend (Server) was where most of the system logic happened.

The _Browser War_ exhausted development of websites to a crawl.

Open Standard that anyone can contribute to and is not controlled by any enterprise became more popular.

A new breed of developers realising the need for a standards, started promoting browser vendors to comply.

Optimising in network calls. the idea that the client side can submit a form using JavaScript and get a response without having to refresh the page became more popular.

Yahoo, Microsoft and Google where experimenting with this. Google developing what can be called the first **web app**.

Since then we continued to optimise on the following areas.

* Availability
	* Caching
	* Local storage
	* Offline availability
* Platform Integration
	* Access to Media API
	* Access to Mobile Device API
* Scale
	* Data storage
	* Data caching
* Speed
	* Network Caching
	* Interface Rendering
* User Experience
	* Responsiveness
	* Animation
* Developer Operations
	* Application architecture
	* Paradigms and Design Patterns
	* Development Tools

Turning what used to be document based sites into desktop like applications. In addition to moving most of the application logic that had to stay due to computation limitation in the server side back to the client side.

## What we talked about

* Watch this If you’re not in my session [What you need to know to become a Web Developer - YouTube](https://www.youtube.com/watch?v=zXqs6X0lzKI)  (20min)
* What you need to know for [Web Development](https://coggle.it/diagram/WD_yrW69HT0L4LaV#) updated graph updated by me

## References
Just getting started with HTML and CSS checkout
	* [W3Schools HTML Guide](http://www.w3schools.com/html/default.asp)
	* [HTML and CSS interactive tutorial with General Assembly]( https://dash.generalassemb.ly/)
Just Getting started with CSS checkout
	* [CSS Diner - Where we feast on CSS Selectors!](https://flukeout.github.io/)
	* [Learn CSS Layout](http://learnlayout.com)
	* [CSS reference from w3schools is good to know what’s there](http://www.w3schools.com/css/default.asp)
	* [A Complete Guide to Flexbox | CSS-Tricks](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)
	* [Exercise in using flex box](http://flexboxfroggy.com/)
* Just Getting started with Javascript From a pogromming background
	* [A re-introduction to JavaScript (JS tutorial)](https://developer.mozilla.org/en-US/docs/Web/JavaScript/A_re-introduction_to_JavaScript)
	* For a full journey checkout [Eloquent JavaScript](http://eloquentjavascript.net/)
	* [JS Jargon](http://jargon.js.org/)
	* For concepts explained in a fun way watch [funfunfunction - YouTube](https://www.youtube.com/channel/UCO1cgjhGzsSYb1rsB4bFe4Q/playlists)

A nice checklist of things you can learn with regards to web technology  [Know it all](https://know-it-all.io/)  for the experienced
